/*
* co_odindex.h - contains OD index defines
*
* Copyright (c) 2012-2019 emotas embedded communication GmbH
*
*-------------------------------------------------------------------
* $Id: co_odindex.h 29114 2019-08-30 15:38:11Z phi $
*-------------------------------------------------------------------
*
*
*
*/

/**
* \brief defines for OD index
*
* \file co_odindex.h - contains defines for OD index
*
*/

#ifndef CO_ODINDEX_H
#define CO_ODINDEX_H 1

#include <co_datatype.h>


/* OD index defines */
#define CO_INDEX_DEVICE_TYPE			0x1000
#define CO_INDEX_ERROR_REGISTER			0x1001
#define CO_INDEX_MANU_STATUS			0x1002
#define CO_INDEX_ERROR_FIELD			0x1003

#define CO_INDEX_SYNC_COBID				0x1005
#define CO_INDEX_SYNC_CYCLE_PERIOD		0x1006
#define CO_INDEX_SYNC_WINDOWS_LENGTH	0x1007
#define CO_INDEX_MANU_DEVICE_NAME		0x1008
#define CO_INDEX_MANU_HW_VERSION		0x1009
#define CO_INDEX_MANU_SW_VERSION		0x100A

#define CO_INDEX_GUARD_TIME				0x100C
#define CO_INDEX_GUARD_LIFE_TIME_FAC	0x100D

#define CO_INDEX_STORE_PARA				0x1010
#define CO_INDEX_RESTORE_PARA			0x1011
#define CO_INDEX_TIME_COBID				0x1012
#define CO_INDEX_HIGH_RES_TIME_STAMP	0x1013
#define CO_INDEX_EMCY_COBID				0x1014
#define CO_INDEX_EMCY_INHIBIT			0x1015
#define CO_INDEX_HEARTBEAT_CONS			0x1016
#define CO_INDEX_HEARTBEAT_PROD			0x1017
#define CO_INDEX_IDENTITY				0x1018
#define CO_INDEX_SYNC_COUNTER			0x1019
#define CO_INDEX_CONFIG_VERIFY			0x1020
#define CO_INDEX_STORE_EDS				0x1021
#define CO_INDEX_STORE_FORMAT			0x1022
#define CO_INDEX_OS_COMMAND				0x1023
#define CO_INDEX_OS_COMMAND_MODE		0x1024
#define CO_INDEX_OS_DEBUG_IF			0x1025
#define CO_INDEX_OS_PROMPT				0x1026
#define CO_INDEX_MODULE_LIST			0x1027
#define CO_INDEX_EMCY_CONSUMER			0x1028
#define CO_INDEX_ERROR_BEHAVIOR			0x1029

#define CO_INDEX_SDO_SERVER				0x1200
#define CO_INDEX_SDO_SERVER_END			0x127f
#define CO_INDEX_SDO_CLIENT				0x1280
#define CO_INDEX_SDO_CLIENT_END			0x12FF

#define CO_INDEX_SRDO_GFC				0x1300
#define CO_INDEX_SRDO_PARA				0x1301
#define CO_INDEX_SRDO_PARA_END			0x1340
#define CO_INDEX_SRDO_MAP				0x1381
#define CO_INDEX_SRDO_MAP_END			0x13C0
#define CO_INDEX_SRDO_CONFIG_VALID		0x13FE
#define CO_INDEX_SRDO_CONFIG_CHECKSUM	0x13FF

#define CO_INDEX_PDO_REC_COMM			0x1400
#define CO_INDEX_PDO_REC_COMM_END		0x15FF
#define CO_INDEX_PDO_REC_MAP			0x1600
#define CO_INDEX_PDO_REC_MAP_END		0x17FF
#define CO_INDEX_PDO_TR_COMM			0x1800
#define CO_INDEX_PDO_TR_COMM_END		0x19FF
#define CO_INDEX_PDO_TR_MAP				0x1A00
#define CO_INDEX_PDO_TR_MAP_END			0x1BFF

#define CO_INDEX_SRD_REQUEST_SDO		0x1F00
#define CO_INDEX_SRD_RELEASE_SDO		0x1F01
#define CO_INDEX_SRD_COBID_TABLE		0x1F02
#define CO_INDEX_SRD_COBID_TABLE		0x1F02
#define CO_INDEX_SRD_CONNPART_1			0x1F03
#define CO_INDEX_SRD_CONNPART_2			0x1F04
#define CO_INDEX_SRD_CONNPART_3			0x1F05
#define CO_INDEX_SRD_CONNPART_4			0x1F06
#define CO_INDEX_SRD_CONN_REQ			0x1F10

#define CO_INDEX_CONSIZE_DCF			0x1F22

#define CO_INDEX_CFG_EXPECTED_DATE		0x1F26
#define CO_INDEX_CFG_EXPECTED_TIME		0x1F27

#define CO_INDEX_DOWNLOAD_PROG_DATA		0x1F50
#define CO_INDEX_DOWNLOAD_PROG_CONTROL	0x1F51

#define CO_INDEX_NMT_MASTER				0x1F80
#define CO_INDEX_NMT_SLAVE_ASSIGNMENT	0x1F81
#define CO_INDEX_NMT_REQUEST			0x1F82
#define CO_INDEX_NMT_REQUEST_NODE_GUARD	0x1F83
#define CO_INDEX_NMT_DEVICE_IDENT		0x1F84
#define CO_INDEX_NMT_VENDOR_IDENT		0x1F85
#define CO_INDEX_NMT_PRODUCT_CODE		0x1F86
#define CO_INDEX_NMT_REVISION_NUMBER	0x1F87
#define CO_INDEX_NMT_SERIAL_NUMBER		0x1F88
#define CO_INDEX_NMT_BOOT_TIME			0x1F89

#define CO_INDEX_FLYMA_TIMEPAR			0x1F90
#define CO_INDEX_FLYMA_DEVPAR			0x1F91

#define CO_INDEX_PDO_SCANNER_LIST		0x1FA0
#define CO_INDEX_PDO_SCANNER_LIST_END	0x1FCF
#define CO_INDEX_PDO_DISPATCHER_LIST	0x1FD0
#define CO_INDEX_PDO_DISPATCHER_LIST_END 0x1FFF

#endif /* CO_ODINDEX_H */
